#include <bits/stdc++.h>

using namespace std;
typedef long long ll;
typedef long double ld;

mt19937 gen(chrono::steady_clock::now().time_since_epoch().count());

int rand(int l, int r) {
    return uniform_int_distribution<int>(l, r)(gen);
}

ll get_answer(ll x, ll y) {
    if (y % x == 0)
        return 0;

    ll k = y / x - 1;
    ll q = y % x;

    if (k == 0)
        return x - q;

    ll t = (x - q + k) / (k + 1);

    // cout << t << " -> " << x - t << ", " << y - t << '\n';
    return t + get_answer(x - t, y - t);
}

ll get_brute_answer(ll x, ll y) {
    ll t = 0;
    while (y % x != 0) {
        x--;
        y--;
        t++;
    }

    return t;
}

void stress() {
    while (true) {
        ll x = rand(1, 100);
        ll y = rand(x, 1000);

        ll ans = get_answer(x ,y);
        ll brute = get_brute_answer(x, y);

        if (ans != brute) {

            cout << x << ' ' << y << '\n';
            cout << ans << " != " << brute << '\n';

            return;
        }
    }
}

void solve() {
    ll x, y;
    cin >> x >> y;

    cout << get_answer(x, y) << '\n';
}

signed main() {
	cin.tie(NULL);
	ios_base::sync_with_stdio(false);

	#ifdef local
    freopen("input", "r", stdin);
	#endif // local

    int t;
    cin >> t;

    while (t--)
	solve();
}
